/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.TimeSpan;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Formatter {
    public static final String NOT_A_NUMBER = "N/A";
    private static final ThreadLocal<Locale> locale = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            return new Locale("cs", "CZ", "");
        }
    };
    private static final ThreadLocal<DateFormat> SHORT_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance(3, locale.get());
        }
    };
    private static final ThreadLocal<DateFormat> SHORT_DATETIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateTimeInstance(3, 3, locale.get());
        }
    };
    private static final ThreadLocal<DateFormat> MEDIUM_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(switch (locale.get().getLanguage()) {
                case "cs" -> "dd.MM.yyyy";
                case "en" -> "MM-dd-yyyy";
                default -> throw new IllegalArgumentException("Unknown locale: " + locale.get().getLanguage());
            });
        }
    };
    private static final ThreadLocal<DateFormat> LONG_DATETIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(switch (locale.get().getLanguage()) {
                case "cs" -> "dd.MM.yyyy HH:mm:ss";
                case "en" -> "MM-dd-yyyy HH:mm:ss";
                default -> throw new IllegalArgumentException("Unknown locale: " + locale.get().getLanguage());
            });
        }
    };
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getTimeInstance(2, locale.get());
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FILE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", DateFormatSymbols.getInstance(locale.get()));
        }
    };
    private static final ThreadLocal<NumberFormat> DEFAULT_NUMBER_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.##", DecimalFormatSymbols.getInstance(locale.get()));
        }
    };
    private static final ThreadLocal<NumberFormat> PERCENT_NUMBER_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return Formatter.createPercentFormat(locale.get());
        }
    };
    private static final ThreadLocal<NumberFormat> DURATION_NUMBER_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(locale.get()));
        }
    };
    private static final ThreadLocal<DecimalFormat> EXCEL_DEFAULT_DECIMAL_NUMBER_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#.##########", new DecimalFormatSymbols(locale.get()));
        }
    };
    private static final ThreadLocal<DecimalFormat> EXCEL_DEFAULT_WHOLE_NUMBER_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#", new DecimalFormatSymbols(locale.get()));
        }
    };
    private static final ThreadLocal<DecimalFormat> EXCEL_FORMATTED_DECIMAL_NUMBER_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#,##0.##########", new DecimalFormatSymbols(locale.get()));
        }
    };
    private static final ThreadLocal<DecimalFormat> EXCEL_FORMATTED_WHOLE_NUMBER_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#,###", new DecimalFormatSymbols(locale.get()));
        }
    };
    private static final ThreadLocal<Map<String, SimpleDateFormat>> USER_DATETIME_FORMAT = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return Maps.newHashMap();
        }
    };
    private static final ImmutableMap<Locale, ImmutableList<DtParser>> FUZZY_DATE_PARSERS;
    private static final ImmutableMap<Locale, ImmutableList<DtParser>> FUZZY_TIME_PARSERS;
    private static final Splitter FUZZY_TIME_SPLITTER;

    public static void setLocale(@Nonnull Locale loc) {
        Preconditions.checkNotNull(loc);
        if (!loc.equals(locale.get())) {
            locale.set(loc);
            SHORT_DATE_FORMAT.remove();
            SHORT_DATETIME_FORMAT.remove();
            MEDIUM_DATE_FORMAT.remove();
            LONG_DATETIME_FORMAT.remove();
            TIME_FORMAT.remove();
            FILE_DATE_FORMAT.remove();
            DEFAULT_NUMBER_FORMAT.remove();
            PERCENT_NUMBER_FORMAT.remove();
            DURATION_NUMBER_FORMAT.remove();
            EXCEL_DEFAULT_DECIMAL_NUMBER_FORMAT.remove();
            EXCEL_DEFAULT_WHOLE_NUMBER_FORMAT.remove();
            EXCEL_FORMATTED_DECIMAL_NUMBER_FORMAT.remove();
            EXCEL_FORMATTED_WHOLE_NUMBER_FORMAT.remove();
        }
    }

    private Formatter() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static String getMediumDateFormatPattern() {
        return ((SimpleDateFormat)MEDIUM_DATE_FORMAT.get()).toPattern();
    }

    @Nonnull
    public static String getShortDateFormatPattern() {
        return ((SimpleDateFormat)SHORT_DATE_FORMAT.get()).toPattern();
    }

    @Nonnull
    public static String getLongDateTimeFormatPattern() {
        return ((SimpleDateFormat)LONG_DATETIME_FORMAT.get()).toPattern();
    }

    private static NumberFormat createPercentFormat(Locale locale) {
        if (locale.getLanguage().equals("cs")) {
            DecimalFormat f = new DecimalFormat("# %", DecimalFormatSymbols.getInstance(locale));
            f.setMultiplier(100);
            f.setRoundingMode(RoundingMode.HALF_UP);
            return f;
        }
        return NumberFormat.getPercentInstance(locale);
    }

    public static String formatBoolean(Boolean value) {
        if (value == null) {
            return Localizer.getString("human_boolean_null");
        }
        if (value.booleanValue()) {
            return Localizer.getString("human_boolean_true");
        }
        return Localizer.getString("human_boolean_false");
    }

    private static String formatGenericNumber(NumberFormat fmt, double v) {
        int multiplier;
        int n = multiplier = fmt instanceof DecimalFormat ? ((DecimalFormat)fmt).getMultiplier() : 1;
        if ((double)multiplier * Math.abs(v) < Math.pow(10.0, -fmt.getMaximumFractionDigits()) / 2.0) {
            return fmt.format(0L);
        }
        return fmt.format(v);
    }

    @Nonnull
    public static String formatNumber(@Nullable Number value) {
        if (value == null || Double.isNaN(value.doubleValue())) {
            return NOT_A_NUMBER;
        }
        return Formatter.formatGenericNumber(DEFAULT_NUMBER_FORMAT.get(), value.doubleValue());
    }

    public static String formatPercent(double ratio) {
        if (Double.isInfinite(ratio) || Double.isNaN(ratio)) {
            return Localizer.getString("human_boolean_null");
        }
        NumberFormat fmt = PERCENT_NUMBER_FORMAT.get();
        return Formatter.formatGenericNumber(fmt, ratio);
    }

    public static DateFormat getLongDateTimeFormat() {
        return LONG_DATETIME_FORMAT.get();
    }

    public static DateFormat getMeduimDateFormat() {
        return MEDIUM_DATE_FORMAT.get();
    }

    public static DateFormat getShortDateFormat() {
        return SHORT_DATE_FORMAT.get();
    }

    public static String fileDateFormat(Date date) {
        return FILE_DATE_FORMAT.get().format(date);
    }

    public static String shortDateFormat(long date) {
        return Formatter.genericFormat(date, SHORT_DATE_FORMAT.get());
    }

    public static String formatShortDateTime(long date) {
        return Formatter.genericFormat(date, SHORT_DATETIME_FORMAT.get());
    }

    @Nonnull
    public static String formatShortDateTime(@Nullable Date date) {
        return Formatter.genericFormat(date, SHORT_DATETIME_FORMAT.get());
    }

    public static String formatMediumDate(long date) {
        return Formatter.genericFormat(date, MEDIUM_DATE_FORMAT.get());
    }

    @Nonnull
    public static String formatMediumDate(@Nullable Date date) {
        return Formatter.genericFormat(date, MEDIUM_DATE_FORMAT.get());
    }

    public static String formatLongDateTime(long date) {
        return Formatter.genericFormat(date, LONG_DATETIME_FORMAT.get());
    }

    @Nonnull
    public static String formatLongDateTime(@Nullable Date date) {
        return Formatter.genericFormat(date, LONG_DATETIME_FORMAT.get());
    }

    public static String formatTime(long date) {
        return Formatter.genericFormat(date, TIME_FORMAT.get());
    }

    @Nonnull
    public static String formatTime(@Nullable Date date) {
        return Formatter.genericFormat(date, TIME_FORMAT.get());
    }

    public static String formatUserTime(String pattern, long date) {
        Map<String, SimpleDateFormat> udf = USER_DATETIME_FORMAT.get();
        SimpleDateFormat format = udf.get(pattern);
        if (format == null) {
            format = new SimpleDateFormat(pattern);
            udf.put(pattern, format);
        }
        return Formatter.genericFormat(date, (DateFormat)format);
    }

    private static String genericFormat(long date, DateFormat format) {
        if (date == -9223372036854775708L) {
            return Localizer.getString("production_tree.unset");
        }
        if (!GeneralizedRequest.isDateValid(date)) {
            return Localizer.getString("production_tree.undefined");
        }
        return format.format(new Date(date));
    }

    @Nonnull
    private static String genericFormat(@Nullable Date date, @Nonnull DateFormat format) {
        if (date != null) {
            long t = date.getTime();
            if (t == -9223372036854775708L) {
                return Localizer.getString("production_tree.unset");
            }
            if (!GeneralizedRequest.isDateValid(t)) {
                return Localizer.getString("production_tree.undefined");
            }
            return format.format(date);
        }
        return Localizer.getString("production_tree.unset");
    }

    public static String formatDuration(long duration) {
        Object val;
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Localizer.getString("production_tree.undefined");
        }
        long remains = duration;
        long d = remains / 86400000L;
        remains = (remains %= 86400000L) < 0L ? -remains : remains;
        long h2 = remains / 3600000L;
        long m3 = (remains %= 3600000L) / 60000L;
        long s2 = (remains %= 60000L) / 1000L;
        if (d != 0L) {
            val = h2 == 0L && m3 == 0L ? String.format("%d %s", d, Localizer.getString("formatter.abr_days")) : String.format("%d %s %02d %s %02d %s", d, Localizer.getString("formatter.abr_days"), h2, Localizer.getString("formatter.abr_hours"), m3, Localizer.getString("formatter.abr_minutes"));
        } else {
            String sign;
            String string = sign = duration < 0L ? "-" : "";
            val = h2 == 0L ? (m3 == 0L ? (s2 == 0L ? (remains == 0L ? "0" : (duration < 0L ? String.format("< -1 %s", Localizer.getString("formatter.abr_sec")) : String.format("< 1 %s", Localizer.getString("formatter.abr_sec")))) : sign + String.format("%02d %s", s2, Localizer.getString("formatter.abr_sec"))) : (s2 == 0L ? sign + String.format("%02d %s", m3, Localizer.getString("formatter.abr_minutes_min")) : sign + String.format("%02d %s %02d %s", m3, Localizer.getString("formatter.abr_minutes_min"), s2, Localizer.getString("formatter.abr_sec")))) : sign + String.format("%02d %s %02d %s", h2, Localizer.getString("formatter.abr_hours"), m3, Localizer.getString("formatter.abr_minutes"));
        }
        return val;
    }

    public static String formatDurationCompact(long duration) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Localizer.getString("production_tree.undefined");
        }
        long remains = duration;
        long d = remains / 86400000L;
        remains = (remains %= 86400000L) < 0L ? -remains : remains;
        long h2 = remains / 3600000L;
        long m3 = (remains %= 3600000L) / 60000L;
        long s2 = (remains %= 60000L) / 1000L;
        Object val = d != 0L ? (h2 == 0L && m3 == 0L ? String.format("%d %s", d, Localizer.getString("formatter.abr_days")) : String.format("%d %s %02d %s", d, Localizer.getString("formatter.abr_days"), h2, Localizer.getString("formatter.abr_hours"))) : (h2 == 0L ? (m3 == 0L ? (s2 == 0L ? (remains == 0L ? "0" : (duration < 0L ? String.format("< -1 %s", Localizer.getString("formatter.abr_sec")) : String.format("< 1 %s", Localizer.getString("formatter.abr_sec")))) : (duration < 0L ? String.format("< -1 %s", Localizer.getString("formatter.abr_minutes_min")) : String.format("< 1 %s", Localizer.getString("formatter.abr_minutes_min")))) : (duration < 0L ? "-" : "") + String.format("%02d %s", m3, Localizer.getString("formatter.abr_minutes_min"))) : (duration < 0L ? "-" : "") + String.format("%02d %s %02d %s", h2, Localizer.getString("formatter.abr_hours"), m3, Localizer.getString("formatter.abr_minutes")));
        return val;
    }

    public static String formatDetailDuration(long duration) {
        long remains = Math.abs(duration);
        StringBuilder result = new StringBuilder(16);
        long d = remains / 86400000L;
        long h2 = (remains %= 86400000L) / 3600000L;
        long m3 = (remains %= 3600000L) / 60000L;
        long s2 = (remains %= 60000L) / 1000L;
        remains %= 1000L;
        if (d > 0L) {
            result.append(d);
            result.append("d ");
        }
        result.append(String.format("%02d:%02d:%02d.%03d", h2, m3, s2, remains));
        return duration < 0L ? "-" + result.toString() : result.toString();
    }

    public static String formatDurationDay(long duration) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Localizer.getString("production_tree.undefined");
        }
        double days = (double)duration / 8.64E7;
        return (DURATION_NUMBER_FORMAT.get().format(days) + " " + Localizer.getString("formatter.abr_days")).trim();
    }

    public static String formatDurationRangeDay(long from, long to) {
        if (!GeneralizedRequest.isDateValid(from)) {
            return Localizer.getString("production_tree.undefined");
        }
        if (!GeneralizedRequest.isDateValid(to)) {
            return Localizer.getString("production_tree.undefined");
        }
        double daysFrom = (double)from / 8.64E7;
        double daysTo = (double)to / 8.64E7;
        return (DURATION_NUMBER_FORMAT.get().format(daysFrom) + " - " + DURATION_NUMBER_FORMAT.get().format(daysTo) + " " + Localizer.getString("formatter.abr_days")).trim();
    }

    private static String formatDuration(long duration, long unit, String unitAbbrKey) {
        if (!GeneralizedRequest.isDateValid(duration)) {
            return Localizer.getString("production_tree.undefined");
        }
        double hours = (double)duration / (double)unit;
        return (DURATION_NUMBER_FORMAT.get().format(hours) + " " + Localizer.getString(unitAbbrKey)).trim();
    }

    public static String formatNh(int hours) {
        return hours + " " + Localizer.getString("formatter.abr_normo_hodina");
    }

    public static String formatNh(double hours) {
        return hours + " " + Localizer.getString("formatter.abr_normo_hodina");
    }

    public static String formatDurationNh(long duration) {
        return Formatter.formatDuration(duration, 3600000L, "formatter.abr_normo_hodina");
    }

    public static String formatDurationNh(double duration) {
        return duration + " " + Localizer.getString("formatter.abr_normo_hodina");
    }

    public static String formatDurationHour(long duration) {
        return Formatter.formatDuration(duration, 3600000L, "formatter.abr_hours");
    }

    public static String formatDurationRangeNh(double from, double to) {
        String fromTxt = Formatter.formatNumber(from);
        String toTxt = Formatter.formatNumber(to);
        return (fromTxt + " - " + toTxt + " " + Localizer.getString("formatter.abr_normo_hodina")).trim();
    }

    public static String formatQty(double qty) {
        return Formatter.formatNumber(qty) + " " + Localizer.getString("formatter.abr_qty");
    }

    public static String getStoreActivityDetail(StoreActivity sa, NumberFormat numberFormat, boolean showTime, boolean showAmount) {
        StringBuilder sb = new StringBuilder(512);
        Formatter.appendStoreActivityDetail(sa, numberFormat, showTime, showAmount, sb);
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendStoreActivityDetail(StoreActivity sa, NumberFormat numberFormat, boolean showTime, boolean showAmount, StringBuilder sb) {
        if (sa.getQty() < 0.0) {
            sb.append(Localizer.getString("timepanel.store_item_renderer.allocation"));
        } else {
            sb.append(Localizer.getString("timepanel.store_item_renderer.lay_in"));
        }
        if (showTime) {
            sb.append(' ');
            sb.append(Formatter.formatShortDateTime(sa.getTime()));
        }
        if (showAmount) {
            sb.append("   ");
            sb.append(numberFormat.format(sa.getAbsQty()));
        } else {
            sb.append(":");
        }
        if (sa instanceof TransactionStoreActivity) {
            TransactionStoreActivity tsa = (TransactionStoreActivity)sa;
            TransactionStoreActivityTarget target = tsa.getTarget();
            sb.append(" ");
            if (!(target instanceof GeneralizedOrderRequest)) return;
            sb.append(Localizer.getString("timepanel.store_item_renderer.tx_gor", ((GeneralizedOrderRequest)target).getId()));
            return;
        } else if (sa instanceof InPlanStoreActivity) {
            StoreActivityOwner owner = ((InPlanStoreActivity)sa).getOwner();
            sb.append(" ");
            if (owner instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_aa", aa.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(aa).getId()));
                return;
            } else if (owner instanceof RebuildActivity) {
                RebuildActivity ra = (RebuildActivity)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_ra", ra.getToType().getName()));
                return;
            } else if (owner instanceof GeneralizedActionRequest) {
                GeneralizedActionRequest gar = (GeneralizedActionRequest)owner;
                if (sa.getQty() > 0.0) {
                    sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gar_pos", gar.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(gar).getId()));
                    return;
                } else {
                    sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gar", gar.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(gar).getId()));
                }
                return;
            } else if (owner instanceof GeneralizedOrderRequest) {
                GeneralizedOrderRequest gor = (GeneralizedOrderRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gor", gor.getId()));
                return;
            } else if (owner instanceof CustomerRequest) {
                CustomerRequest cr = (CustomerRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_custreq", cr.getId()));
                return;
            } else {
                if (!(owner instanceof SupplyRequest)) throw new IllegalStateException("Unexpected store activity owner in " + sa);
                SupplyRequest sr = (SupplyRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_supreq", sr.getId()));
            }
            return;
        } else {
            if (!(sa instanceof ExternalStoreActivity)) throw new IllegalStateException("Unknown kind of store activity " + sa);
            if (((ExternalStoreActivity)sa).getDescription() == null) return;
            sb.append(" ");
            sb.append(((ExternalStoreActivity)sa).getDescription());
        }
    }

    @Nullable
    public static Number parseNumber(@Nonnull String value) {
        Preconditions.checkNotNull(value);
        ParsePosition pp = new ParsePosition(0);
        Number res = DEFAULT_NUMBER_FORMAT.get().parse(value.replace(' ', '\u00a0'), pp);
        if (pp.getIndex() != value.length()) {
            res = null;
        }
        return res;
    }

    @Nullable
    public static Date parseDate(@Nonnull String value) {
        Preconditions.checkNotNull(value);
        ParsePosition pp = new ParsePosition(0);
        Date d = LONG_DATETIME_FORMAT.get().parse(value, pp);
        int li = pp.getIndex();
        if (li != value.length()) {
            pp.setIndex(0);
            Date s2 = SHORT_DATE_FORMAT.get().parse(value, pp);
            if (s2 != null && pp.getIndex() > li) {
                d = s2;
            }
        }
        return d;
    }

    public static TimeSpan parseTimeFuzzy(@Nonnull String value) {
        TimeSpan res;
        List<String> parts = FUZZY_TIME_SPLITTER.splitToList(value);
        long[] lens = new long[]{3600000L, 60000L, 1000L};
        try {
            long start = 0L;
            start -= (long)TimeZone.getDefault().getOffset(start);
            switch (parts.size()) {
                case 3: {
                    start += (long)Integer.parseInt(parts.get(2)) * 1000L;
                }
                case 2: {
                    start += (long)Integer.parseInt(parts.get(1)) * 60000L;
                }
                case 1: {
                    break;
                }
                default: {
                    return null;
                }
            }
            long end = (start += (long)Integer.parseInt(parts.get(0)) * 3600000L) + lens[parts.size() - 1];
            res = TimeSpan.fromStartEnd(start, end);
        }
        catch (NumberFormatException e) {
            res = null;
        }
        return res;
    }

    private static boolean isDatetimeSeparator(char ch) {
        return ch == '.' || ch == ':' || ch == '/' || ch == '-';
    }

    @VisibleForTesting
    static String cleanupDatetime(@Nonnull String value) {
        StringBuilder sb = new StringBuilder();
        int state = 1;
        block5: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) {
                        state = 1;
                    } else if (Formatter.isDatetimeSeparator(ch)) {
                        state = 2;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case 1: {
                    if (Formatter.isDatetimeSeparator(ch)) {
                        if (sb.length() == 0) continue block5;
                        sb.setLength(sb.length() - 1);
                        state = 2;
                        sb.append(ch);
                        continue block5;
                    }
                    if (Character.isWhitespace(ch)) continue block5;
                    state = 0;
                    sb.append(ch);
                    continue block5;
                }
                case 2: {
                    if (Character.isWhitespace(ch)) continue block5;
                    state = 0;
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("state " + i);
                }
            }
        }
        if (state == 1 && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static TimeSpan toTimeSpan(LocalDateTime dt, TemporalAmount length) {
        ZonedDateTime start = dt.atZone(ZoneId.systemDefault());
        ZonedDateTime end = start.plus(length);
        return TimeSpan.fromStartEnd(start.toInstant().toEpochMilli(), end.toInstant().toEpochMilli());
    }

    @Nullable
    public static TimeSpan parseDateFuzzy(@Nonnull String value) {
        Locale loc = locale.get();
        List dateParsers = FUZZY_DATE_PARSERS.get(loc);
        List timeParsers = FUZZY_TIME_PARSERS.get(loc);
        Preconditions.checkState(dateParsers != null && timeParsers != null, "unsupported locale %s", (Object)loc);
        value = Formatter.cleanupDatetime(value);
        ParsePosition pp = new ParsePosition(0);
        for (DtParser dateParser : dateParsers) {
            LocalDate d = dateParser.parseLocalDateFromStart(value, pp);
            if (d == null) continue;
            String rest = value.substring(pp.getIndex()).stripLeading();
            if (rest.isEmpty()) {
                return Formatter.toTimeSpan(d.atStartOfDay(), dateParser.length);
            }
            if (!dateParser.canTimeFollow()) continue;
            for (DtParser timeParser : timeParsers) {
                LocalTime t = timeParser.parseLocalTimeFromStart(rest, pp);
                if (t == null || pp.getIndex() != rest.length()) continue;
                return Formatter.toTimeSpan(d.atTime(t), timeParser.length);
            }
        }
        Number n = Formatter.parseNumber(value);
        if (n != null) {
            int x = n.intValue();
            try {
                if (x >= 1900) {
                    return Formatter.toTimeSpan(LocalDateTime.of(x, 1, 1, 0, 0), Period.ofYears(1));
                }
                return Formatter.toTimeSpan(LocalDate.now(ZoneId.systemDefault()).withDayOfMonth(x).atStartOfDay(), Period.ofDays(1));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public static Optional<DurationParseResult> parseDuration(@Nonnull String value) {
        String d = Localizer.getString("formatter.abr_days").toLowerCase().trim();
        String h2 = Localizer.getString("formatter.abr_hours").toLowerCase().trim();
        String m3 = Localizer.getString("formatter.abr_minutes").toLowerCase().trim();
        ParsePosition pp = new ParsePosition(0);
        Duration dur = Duration.ZERO;
        ChronoUnit unit = ChronoUnit.DAYS;
        int parsedPartsCnt = 0;
        while (pp.getIndex() < value.length()) {
            while (pp.getIndex() < value.length() && Character.isWhitespace(value.charAt(pp.getIndex()))) {
                pp.setIndex(pp.getIndex() + 1);
            }
            int start = pp.getIndex();
            Number n = DEFAULT_NUMBER_FORMAT.get().parse(value, pp);
            if (start < pp.getIndex()) {
                while (pp.getIndex() < value.length() && Character.isWhitespace(value.charAt(pp.getIndex()))) {
                    pp.setIndex(pp.getIndex() + 1);
                }
                String rest = value.substring(pp.getIndex());
                if (rest.startsWith(d) || rest.isEmpty()) {
                    pp.setIndex(pp.getIndex() + d.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.DAYS);
                } else if (rest.startsWith(h2)) {
                    pp.setIndex(pp.getIndex() + h2.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.HOURS);
                    unit = ChronoUnit.HOURS;
                } else if (rest.startsWith(m3)) {
                    pp.setIndex(pp.getIndex() + m3.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.MINUTES);
                    unit = ChronoUnit.MINUTES;
                } else {
                    return Optional.empty();
                }
                ++parsedPartsCnt;
                continue;
            }
            return Optional.empty();
        }
        return parsedPartsCnt > 0 ? Optional.of(new DurationParseResult(dur, unit)) : Optional.empty();
    }

    @Nullable
    public static TimeSpan parseTimeRelative(@Nonnull String s2, long ref) {
        Preconditions.checkNotNull(s2, "string in parseTimeRelative");
        if (s2.isEmpty()) {
            return null;
        }
        int dir = 1;
        if (s2.charAt(0) == '-') {
            s2 = s2.substring(1);
            dir = -1;
        } else if (s2.charAt(0) == '+') {
            s2 = s2.substring(1);
        }
        if (s2.isEmpty()) {
            return null;
        }
        Optional<DurationParseResult> durRes = Formatter.parseDuration(s2);
        if (durRes.isEmpty()) {
            return null;
        }
        Duration dur = durRes.get().getDuration().multipliedBy(dir);
        TemporalUnit unit = durRes.get().getUnit();
        Instant start = Instant.ofEpochMilli(ref).plus(dur).truncatedTo(unit);
        Instant end = start.plus(unit.getDuration());
        return TimeSpan.fromStartEnd(start.toEpochMilli(), end.toEpochMilli());
    }

    public static Long parseExcelLong(@Nonnull String s2) throws IllegalArgumentException {
        try {
            return Long.valueOf(s2);
        }
        catch (Exception exception) {
            long d2;
            ParsePosition pos;
            try {
                pos = new ParsePosition(0);
                d2 = EXCEL_DEFAULT_WHOLE_NUMBER_FORMAT.get().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d2) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                d2 = EXCEL_FORMATTED_WHOLE_NUMBER_FORMAT.get().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d3) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                long d4 = EXCEL_DEFAULT_DECIMAL_NUMBER_FORMAT.get().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d4;
                }
            }
            catch (Exception d4) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                long d5 = EXCEL_FORMATTED_DECIMAL_NUMBER_FORMAT.get().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d5;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalArgumentException();
        }
    }

    public static Double parseExcelDouble(@Nonnull String s2) throws IllegalArgumentException {
        try {
            return Double.valueOf(s2);
        }
        catch (Exception exception) {
            double d2;
            ParsePosition pos;
            try {
                pos = new ParsePosition(0);
                d2 = EXCEL_DEFAULT_DECIMAL_NUMBER_FORMAT.get().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d2) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                d2 = EXCEL_FORMATTED_DECIMAL_NUMBER_FORMAT.get().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d3) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                double d4 = EXCEL_DEFAULT_WHOLE_NUMBER_FORMAT.get().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d4;
                }
            }
            catch (Exception d4) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                double d5 = EXCEL_FORMATTED_WHOLE_NUMBER_FORMAT.get().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d5;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalArgumentException();
        }
    }

    static {
        Locale locEn = Locale.US;
        Locale locCs = new Locale("cs", "CZ");
        FUZZY_DATE_PARSERS = ImmutableMap.builder().put(locCs, ImmutableList.of(new DtParser("d.M.u", locCs, Period.ofDays(1)), new DtParser("d.M.", locCs, Period.ofDays(1)), new DtParser("d.MMM", locCs, Period.ofDays(1)), new DtParser("d.MMMM", locCs, Period.ofDays(1)), new DtParser("LLL u", locCs, Period.ofMonths(1)), new DtParser("LLLL u", locCs, Period.ofMonths(1)), new DtParser("LLL", locCs, Period.ofMonths(1)), new DtParser("LLLL", locCs, Period.ofMonths(1)))).put(locEn, ImmutableList.of(new DtParser("M-d-u", locEn, Period.ofDays(1)), new DtParser("M/d/u", locEn, Period.ofDays(1)), new DtParser("M-d", locEn, Period.ofDays(1)), new DtParser("M/d", locEn, Period.ofDays(1)), new DtParser("MMM-d", locEn, Period.ofDays(1)), new DtParser("MMM/d", locEn, Period.ofDays(1)), new DtParser("MMM d", locEn, Period.ofDays(1)), new DtParser("MMMM-d", locEn, Period.ofDays(1)), new DtParser("MMMM/d", locEn, Period.ofDays(1)), new DtParser("MMMM d", locEn, Period.ofDays(1)), new DtParser("LLL u", locEn, Period.ofMonths(1)), new DtParser("LLLL u", locEn, Period.ofMonths(1)), new DtParser[]{new DtParser("LLL", locEn, Period.ofMonths(1)), new DtParser("LLLL", locEn, Period.ofMonths(1))})).build();
        FUZZY_TIME_PARSERS = ImmutableMap.builder().put(locCs, ImmutableList.of(new DtParser("H:m:s.SSS", locCs), new DtParser("H:m:s", locCs, Duration.ofSeconds(1L)), new DtParser("H:m", locCs, Duration.ofMinutes(1L)), new DtParser("H", locCs, Duration.ofHours(1L)))).put(locEn, ImmutableList.of(new DtParser("H:m:s.SSS", locEn), new DtParser("H:m:s", locEn, Duration.ofSeconds(1L)), new DtParser("H:m", locEn, Duration.ofMinutes(1L)), new DtParser("H", locEn, Duration.ofHours(1L)))).build();
        FUZZY_TIME_SPLITTER = Splitter.onPattern("[.:]");
    }

    private static class DtParser {
        final DateTimeFormatter formatter;
        final TemporalAmount length;

        private DtParser(String pattern, Locale loc, TemporalAmount length) {
            this.formatter = DateTimeFormatter.ofPattern(pattern, loc);
            this.length = length;
        }

        DtParser(String pattern, Locale loc) {
            this(pattern, loc, Duration.ZERO);
        }

        boolean canTimeFollow() {
            return this.length.equals(Period.ofDays(1));
        }

        @Nullable
        <T> T parseFromStart(String value, ParsePosition pp, TemporalQuery<T> x) {
            pp.setIndex(0);
            pp.setErrorIndex(-1);
            TemporalAccessor ta = this.formatter.parseUnresolved(value, pp);
            if (pp.getErrorIndex() >= 0) {
                return null;
            }
            try {
                return x.queryFrom(ta);
            }
            catch (DateTimeException e) {
                return null;
            }
        }

        private static LocalDate toLocalDate(TemporalAccessor ta) {
            LocalDate now = LocalDate.now(ZoneId.systemDefault());
            int y = ta.isSupported(ChronoField.YEAR) ? ta.get(ChronoField.YEAR) : now.getYear();
            int m3 = ta.isSupported(ChronoField.MONTH_OF_YEAR) ? ta.get(ChronoField.MONTH_OF_YEAR) : now.getMonthValue();
            int d = ta.isSupported(ChronoField.DAY_OF_MONTH) ? ta.get(ChronoField.DAY_OF_MONTH) : 1;
            return LocalDate.of(y, m3, d);
        }

        private static LocalTime toLocalTime(TemporalAccessor ta) {
            int h2 = ta.isSupported(ChronoField.HOUR_OF_DAY) ? ta.get(ChronoField.HOUR_OF_DAY) : 0;
            int m3 = ta.isSupported(ChronoField.MINUTE_OF_HOUR) ? ta.get(ChronoField.MINUTE_OF_HOUR) : 0;
            int s2 = ta.isSupported(ChronoField.SECOND_OF_MINUTE) ? ta.get(ChronoField.SECOND_OF_MINUTE) : 0;
            int n = ta.isSupported(ChronoField.NANO_OF_SECOND) ? ta.get(ChronoField.NANO_OF_SECOND) : 0;
            return LocalTime.of(h2, m3, s2, n);
        }

        LocalDate parseLocalDateFromStart(String value, ParsePosition pp) {
            return this.parseFromStart(value, pp, DtParser::toLocalDate);
        }

        LocalTime parseLocalTimeFromStart(String value, ParsePosition pp) {
            return this.parseFromStart(value, pp, DtParser::toLocalTime);
        }
    }

    public static class DurationParseResult {
        private final Duration duration;
        private final TemporalUnit unit;

        @VisibleForTesting
        DurationParseResult(@Nonnull Duration duration, @Nonnull TemporalUnit unit) {
            this.duration = Preconditions.checkNotNull(duration);
            this.unit = Preconditions.checkNotNull(unit);
        }

        public Duration getDuration() {
            return this.duration;
        }

        public TemporalUnit getUnit() {
            return this.unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DurationParseResult)) {
                return false;
            }
            DurationParseResult that = (DurationParseResult)o;
            return this.duration.equals(that.duration) && this.unit.equals(that.unit);
        }

        public int hashCode() {
            return Objects.hash(this.duration, this.unit);
        }

        public String toString() {
            return new StringJoiner(", ", DurationParseResult.class.getSimpleName() + "[", "]").add("duration=" + this.duration).add("unit=" + this.unit).toString();
        }
    }
}

